---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local trackerOptionsLocales = {
    ["Tracker"] = {
        ["ptBR"] = "Rastreador",
        ["ruRU"] = "Трекер Questie",
        ["deDE"] = "Tracker",
        ["koKR"] = "추적기",
        ["esMX"] = "Rastreador",
        ["enUS"] = true,
        ["zhCN"] = "追踪",
        ["zhTW"] = "追蹤",
        ["esES"] = "Rastreador",
        ["frFR"] = "Suivi",
    },
    ["Questie Tracker Options"] = {
        ["ptBR"] = "Opções do rastreador para missões",
        ["ruRU"] = "Настройки трекера (окна отслеживания) заданий",
        ["deDE"] = "Questie-Tracker Einstellungen",
        ["koKR"] = "퀘스트 추적기 설정",
        ["esMX"] = "Opciones del Rastreador",
        ["enUS"] = true,
        ["zhCN"] = "任务追踪选项",
        ["zhTW"] = "任務追蹤選項",
        ["esES"] = "Opciones del Rastreador",
        ["frFR"] = "Options du suivi des quêtes",
    },
    ["Auto Track Quests"] = {
        ["ptBR"] = "Missões de rastreamento automático",
        ["ruRU"] = "Автоотслеживание",
        ["deDE"] = "Quests automatisch verfolgen",
        ["koKR"] = "자동 추적 퀘스트",
        ["esMX"] = "Misiones de seguimiento automático",
        ["enUS"] = true,
        ["zhCN"] = "自动追踪任务",
        ["zhTW"] = "自動追蹤所有任務",
        ["esES"] = "Misiones de seguimiento automático",
        ["frFR"] = "Suivi auto des quêtes",
    },
    ["This is the same as 'Enable automatic quest tracking' in interface options. When enabled, the Questie Tracker will automatically track all quests in your log. This prevents shift-click manual tracking."] = {
        ["ptBR"] = "É o mesmo que 'Ativar rastreamento automático de missões' nas opções da interface. Quando ativado, o Questie Rastreador rastreia automaticamente todas as missões em seu registro. Isso evita o rastreamento manual com a tecla Shift pressionada.",
        ["ruRU"] = "Когда включено, трекер будет автоматически отслеживать все задания в вашем журнале. Это избавляет от ручного слежения за заданиями через Shift-клик",
        ["deDE"] = "Dies ist dasselbe wie 'Automatische Questverfolgung aktivieren' in den Schnittstellenoptionen. Wenn aktiviert, verfolgt der Questie Tracker automatisch alle Quests im Questlog. Dies verhindert die manuelle Verfolgung durch 'Umschalten + Linksklick'.",
        ["koKR"] = "인터페이스 옵션의 '자동 퀘스트 추적 사용 '과 동일합니다. 활성화하면 Questie Tracker가 로그의 모든 퀘스트를 자동으로 추적합니다. 이렇게하면 Shift- 클릭 수동 추적이 방지됩니다.",
        ["esMX"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el Rastreador de Questie rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["enUS"] = true,
        ["zhCN"] = "这与界面选项中的“启用自动任务跟踪”相同。 启用后，Questie 追踪将自动追踪日志中的所有任务。 这样可以防止按住Shift键单击手动追踪。",
        ["zhTW"] = "這和暴雪的「自動任務追蹤」是相同的。啟用後，Questie任務追蹤會自動追蹤任務日誌中的所有任務",
        ["esES"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el Rastreador de Questie rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["frFR"] = "Cela revient à utiliser 'Activer le suivi automatique des quêtes' dans les options d'interface. Le suivi des quêtes suivra alors automatiquement toutes les quêtes de votre journal et cela empêchera le suivi manuel Maj-clic.",
    },
    ["Show Quest Level"] = {
        ["ptBR"] = "Mostrar nível da missão",
        ["ruRU"] = "Уровень заданий",
        ["deDE"] = "Questlevel anzeigen",
        ["koKR"] = "퀘스트 레벨 표시",
        ["esMX"] = "Mostrar nivel de misión",
        ["enUS"] = true,
        ["zhCN"] = "显示任务等级",
        ["zhTW"] = "顯示任務等級",
        ["esES"] = "Mostrar nivel de misión",
        ["frFR"] = "Afficher le niveau des quêtes",
    },
    ["When this is checked, the Quest Level Tags for Quest Titles will show in the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, as tags de nível de missão para títulos de missão serão exibidas no Questie Rastreador.",
        ["ruRU"] = "Показать/скрыть уровень заданий слева от их названий",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Quest-Level-Tags für Quest-Titel im Questie-Tracker angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 퀘스트 제목에 대한 퀘스트 레벨 태그가 Questie 트래커에 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el Rastreador de Questie.",
        ["enUS"] = true,
        ["zhCN"] = "选中后，任务标题的任务等级将显示在Questie追踪窗口",
        ["zhTW"] = "將任務等級顯示在追蹤視窗",
        ["esES"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el Rastreador de Questie.",
        ["frFR"] = "Affiche le niveau des quêtes avec le titre des quêtes.",
    },
    ["When this is checked, completed quests will show in the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, as missões concluídas serão exibidas no Questie Rastreador.",
        ["ruRU"] = "Показать/скрыть выполненные задания в трекере",
        ["deDE"] = "Wenn dies aktiviert ist, werden abgeschlossene Quests im Questie Tracker angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 Questie 추적기에 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, las misiones completadas se mostrarán en el Rastreador de Questie.",
        ["enUS"] = true,
        ["zhCN"] = "选中后，已完成的任务将显示在Questie追踪列表中",
        ["zhTW"] = "讓已完成的任務持續顯示在任務追蹤列表中",
        ["esES"] = "Cuando esto está marcado, las misiones completadas se mostrarán en el Rastreador de Questie.",
        ["frFR"] = "Active l'affichage des quêtes terminées dans le suivi des quêtes.",
    },
    ["Auto Move Header"] = {
        ["ptBR"] = "Mover cabeçalho automaticamente",
        ["ruRU"] = "Автоперемещение",
        ["deDE"] = "Header automatisch verschieben",
        ["koKR"] = "자동 이동 헤더",
        ["esMX"] = "Encabezado de movimiento automático",
        ["enUS"] = true,
        ["zhCN"] = "自动移动标题",
        ["zhTW"] = "自動移動標題列",
        ["esES"] = "Encabezado de movimiento automático",
        ["frFR"] = "Ajustement auto",
    },
    ["Show Blizzard Timer"] = {
        ["ptBR"] = "Mostrar temporizador da Blizzard",
        ["ruRU"] = "Таймер Blizzard",
        ["deDE"] = "Blizzard Timer anzeigen",
        ["koKR"] = "블리자드 타이머 표시",
        ["esMX"] = "Mostrar temporizador de Blizzard",
        ["enUS"] = true,
        ["zhCN"] = "显示暴雪计时器",
        ["zhTW"] = "顯示暴雪任務計時器",
        ["esES"] = "Mostrar temporizador de Blizzard",
        ["frFR"] = "Chrono par défaut",
    },
    ["When this is checked, the default Blizzard Timer Frame for quests will be shown instead of being embedded inside the tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Quadro de temporizador padrão da Blizzard para missões será mostrado em vez de incorporado no rastreador.",
        ["ruRU"] = "Когда включено, будет отображаться стандартный таймер Blizzard вместо встраивания его в трекер",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Standard-Blizzard-Timer-Frame für Quests angezeigt, anstatt in den Tracker eingebettet zu sein.",
        ["koKR"] = "이 옵션을 선택하면 추적기에 내장 된 대신 퀘스트에 대한 기본 블리자드 타이머 프레임이 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "启用后，任务计时器将会显示",
        ["zhTW"] = "啟用後，任務的預設計時器將會被顯示",
        ["esES"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["frFR"] = "Active l'affichage du chronomètre de l'interface de base pour les quêtes au lieu d'indiquer le temps restant directement dans le suivi des quêtes.",
    },
    ["Hide Icons"] = {
        ["ptBR"] = "Ocultar ícones",
        ["ruRU"] = "Скрыть значки",
        ["deDE"] = "Icons verstecken",
        ["koKR"] = "아이콘 가리기",
        ["esMX"] = "Esconder iconos",
        ["enUS"] = true,
        ["zhCN"] = "隐藏标记",
        ["zhTW"] = "隱藏標記",
        ["esES"] = "Esconder iconos",
        ["frFR"] = "Masquer les icônes",
    },
    ["Fade Min/Max BTNs"] = {
        ["ptBR"] = "Desvanecer botões Min/Max",
        ["ruRU"] = "Скрытие '+' и '–'",
        ["deDE"] = "Min/Max ausblenden",
        ["koKR"] = "페이드 최소 / 최대 BTN",
        ["esMX"] = "Desvanecer botones Min/Máx",
        ["enUS"] = true,
        ["zhCN"] = "淡化按钮",
        ["zhTW"] = "淡化最大化/最小化按鈕",
        ["esES"] = "Desvanecer botones Min/Máx",
        ["frFR"] = "Fondu des boutons +/-",
    },
    ["When this is checked, the Minimize and Maximize Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões Minimizar e Maximizar desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки сворачивания и разворачивания заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen zum Minimieren und Maximieren von Quests ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 사용하지 않을 때 최소화 및 최대화 버튼이 사라지고 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中时，自动淡化按钮",
        ["zhTW"] = "未使用時，自動淡化最大化/最小化按鈕",
        ["esES"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons + et - ce qui les rend transparents en dehors du survol de la souris.",
    },
    ["Fade Quest Item BTNs"] = {
        ["ptBR"] = "Desvanecer BTNs do item de missão",
        ["ruRU"] = "Скрытие предметов",
        ["deDE"] = "Questgegenstände ausblenden",
        ["koKR"] = "페이드 퀘스트 아이템 BTN",
        ["esMX"] = "Desvanecer botones de objetos de misiones",
        ["enUS"] = true,
        ["zhCN"] = "淡化任务道具按钮",
        ["zhTW"] = "淡化任務物品按鈕",
        ["esES"] = "Desvanecer botones de objetos de misiones",
        ["frFR"] = "Fondu des objets de quête",
    },
    ["When this is checked, the Quest Item Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões de itens da missão desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки предметов заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen für die Questgegenstände ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 항목을 체크하면 퀘스트 아이템 버튼이 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los Botones de Objetos de Búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中此项时，任务项按钮将在不使用时自动淡化",
        ["zhTW"] = "未使用時，自動淡化任務物品按鈕",
        ["esES"] = "Cuando esto está marcado, los Botones de Objetos de Búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons d'objet de quête ce qui les rend transparents en dehors du survol de la souris.",
    },
    ["Objective Color"] = {
        ["ptBR"] = "Cor do objectivo",
        ["ruRU"] = "Цвет целей",
        ["deDE"] = "Questzielfarbe",
        ["koKR"] = "퀘스트 목표 색상",
        ["esMX"] = "Color de objectivo",
        ["enUS"] = true,
        ["zhCN"] = "目标着色",
        ["zhTW"] = "目標著色",
        ["esES"] = "Color de objectivo",
        ["frFR"] = "Couleur des objectifs :",
    },
    ["Change the color of objectives in the tracker by how complete they are."] = {
        ["ptBR"] = "Altere a cor dos objetivos no Rastreador de acordo com a integridade",
        ["ruRU"] = "Изменение цвета целей заданий в трекере в зависимости от прогресса выполнения",
        ["deDE"] = "Verändert die Farbe von Questzielen in Abhängigkeit zum Fortschritt.",
        ["koKR"] = "퀘스트 추적기에서 퀘스트 진행도에 따라 퀘스트 목표 색상을 변경합니다.",
        ["esMX"] = "Cambia el color de objetivos en el rastreador por lo completos que estén.",
        ["enUS"] = true,
        ["zhCN"] = "按照任务目标的进度，对追踪框的任务目标文字染色。",
        ["zhTW"] = "根據任務目標的進度，著色追蹤框的任務目標文字",
        ["esES"] = "Cambia el color de objetivos en el rastreador por lo completos que estén.",
        ["frFR"] = "Change la couleur des objectifs dans le suivi en fonction de leur progression.",
    },
    ["Red to Green"] = {
        ["ptBR"] = "Vermelho ao verde",
        ["ruRU"] = "От красного к зеленому",
        ["deDE"] = "Rot zu Grün",
        ["koKR"] = "빨간색에서 초록색",
        ["esMX"] = "Rojo a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由红至绿",
        ["zhTW"] = "由紅至綠",
        ["esES"] = "Rojo a Verde",
        ["frFR"] = "Rouge à vert",
    },
    ["White to Green"] = {
        ["ptBR"] = "Branco ao verde",
        ["ruRU"] = "От белого к зеленому",
        ["deDE"] = "Weiß zu Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由白至绿",
        ["zhTW"] = "由白至綠",
        ["esES"] = "Blanco a Verde",
        ["frFR"] = "Blanc à vert",
    },
    ["White and Green"] = {
        ["ptBR"] = "Branco e verde",
        ["ruRU"] = "Белый и зеленый",
        ["deDE"] = "Weiß und Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco y Verde",
        ["enUS"] = true,
        ["zhCN"] = "白和绿",
        ["zhTW"] = "白和綠",
        ["esES"] = "Blanco y Verde",
        ["frFR"] = "Blanc et vert",
    },
    ["White"] = {
        ["ptBR"] = "Branco",
        ["ruRU"] = "Белый",
        ["deDE"] = "Weiß",
        ["koKR"] = "하얀색",
        ["esMX"] = "Blanco",
        ["enUS"] = true,
        ["zhCN"] = "白色",
        ["zhTW"] = "白色",
        ["esES"] = "Blanco",
        ["frFR"] = "Blanc",
    },
    ["Objective Sorting"] = {
        ["ptBR"] = "Classificando objetivos",
        ["ruRU"] = "Сортировка целей",
        ["deDE"] = "Questzielsortierung",
        ["koKR"] = "퀘스트 목표 정렬",
        ["esMX"] = "Orden de objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标排序",
        ["zhTW"] = "目標排序",
        ["esES"] = "Orden de objetivos",
        ["frFR"] = "Méthode de tri des objectifs :",
    },
    ["How objectives are sorted in the tracker."] = {
        ["ptBR"] = "Como os objectivos são classificadas no Rastreador",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере",
        ["deDE"] = "Wie Questziele im Tracker sortiert werden.",
        ["koKR"] = "추적기에서 퀘스트 목표를 어떻게 정렬해서 보여줄지 설정합니다.",
        ["esMX"] = "La manera que se ordena los objetivos en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "追踪列表中的任务要如何排序",
        ["zhTW"] = "追蹤列表中的任務要如何排序",
        ["esES"] = "La manera que se ordena los objetivos en el rastreador.",
        ["frFR"] = "Comment les objectifs sont triés dans le Traqueur",
    },
    ["By Level"] = {
        ["ptBR"] = "Por nivel",
        ["ruRU"] = "По уровню (возр.)",
        ["deDE"] = "Nach Level",
        ["koKR"] = "레벨 순서",
        ["esMX"] = "Por Nivel",
        ["enUS"] = true,
        ["zhCN"] = "根据等级正序排列",
        ["zhTW"] = "根據等級正序排列",
        ["esES"] = "Por Nivel",
        ["frFR"] = "Par niveau",
    },
    ["By Level (Reversed)"] = {
        ["ptBR"] = "Por nível (invertido)",
        ["ruRU"] = "По уровню (убыв.)",
        ["deDE"] = "Nach Level (Absteigend)",
        ["koKR"] = "레벨 순서 (역순)",
        ["esMX"] = "Por Nivel (Inverso)",
        ["enUS"] = true,
        ["zhCN"] = "根据等级反序排列",
        ["zhTW"] = "根據等級反序排列",
        ["esES"] = "Por Nivel (Inverso)",
        ["frFR"] = "Par niveau (inversé)",
    },
    ["By Zone"] = {
        ["ptBR"] = "Por zona",
        ["ruRU"] = "По игровой зоне",
        ["deDE"] = "Nach Zone",
        ["koKR"] = "지역별",
        ["esMX"] = "Por zona",
        ["enUS"] = true,
        ["zhCN"] = "按区域",
        ["zhTW"] = "依照地區",
        ["esES"] = "Por zona",
        ["frFR"] = "Par zone",
    },
    ["By %% Completed"] = {
        ["ptBR"] = "Por %% concluído",
        ["ruRU"] = "По %% выполнения",
        ["deDE"] = "Nach abgeschlossenen %%",
        ["koKR"] = "완료한 %% 순서",
        ["esMX"] = "Por %% Completado",
        ["enUS"] = true,
        ["zhCN"] = "根据进度百分比",
        ["zhTW"] = "根據進度百分比",
        ["esES"] = "Por %% Completado",
        ["frFR"] = "Par %% accompli",
    },
    ["By Proximity"] = {
        ["ptBR"] = "Por proximidade",
        ["ruRU"] = "По близости",
        ["deDE"] = "Nach Nähe",
        ["koKR"] = "가까운",
        ["esMX"] = "Por proximidad",
        ["enUS"] = true,
        ["zhCN"] = "按照远近",
        ["zhTW"] = "依照遠近",
        ["esES"] = "Por proximidad",
        ["frFR"] = "Par proximité",
    },
    ["Set |cFF54e33bTomTom|r Target"] = {
        ["ptBR"] = "Defina o alvo |cFF54e33bTomTom|r",
        ["ruRU"] = "Установить точку |cFF54e33bTomTom|r",
        ["deDE"] = "|cFF54e33bTomTom|r-Ziel setzen",
        ["koKR"] = "|cFF54e33bTomTom|r 대상 설정",
        ["esMX"] = "Establecer objetivo de|cFF54e33bTomTom|r",
        ["enUS"] = true,
        ["zhCN"] = "显示|cFF54e33bTomTom|r箭头",
        ["zhTW"] = "顯示|cFF54e33bTomTom|r箭頭",
        ["esES"] = "Establecer objetivo de|cFF54e33bTomTom|r",
        ["frFR"] = "Définir un point |cFF54e33bTomTom|r",
    },
    ["The tracker shortcut to open TomTom"] = {
        ["ptBR"] = "Atalho para abrir TomTom",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom",
        ["deDE"] = "Der Tracker-Shortcut, um TomTom zu öffnen The tracker shortcut to open TomTom.",
        ["koKR"] = "추적기에서 TomTom 애드온을 여는 단축키를 설정합니다.",
        ["esMX"] = "El atajo del rastreador para abrir TomTom",
        ["enUS"] = true,
        ["zhCN"] = "在任务追踪上开启TomTom的快捷键",
        ["zhTW"] = "在任務追蹤上開啟TomTom的快捷鍵",
        ["esES"] = "El atajo del rastreador para abrir TomTom",
        ["frFR"] = "Définis le raccourci servant à ouvrir TomTom.",
    },
    ["Minimize in combat"] = {
        ["ptBR"] = "Minimizar em combate",
        ["ruRU"] = "Свернуть в бою",
        ["deDE"] = "Im Kampf minimieren",
        ["koKR"] = "전투 최소화",
        ["esMX"] = "Minimizar en combate",
        ["enUS"] = true,
        ["zhCN"] = "在战斗中最小化",
        ["zhTW"] = "戰鬥時最小化追蹤視窗",
        ["esES"] = "Minimizar en combate",
        ["frFR"] = "Réduire en combat",
    },
    ["When this is checked, the Tracker will automatically be minimized while entering combat."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será automaticamente minimizado ao entrar em combate.",
        ["ruRU"] = "Когда включено, при входе в бой трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Eintritt in den Kampf automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 전투에 들어가는 동안 트래커가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar en combate",
        ["enUS"] = true,
        ["zhCN"] = "选中后，在进入战斗状态时，追踪器将自动最小化。",
        ["zhTW"] = "進入戰鬥時，自動最小化任務追蹤視窗",
        ["esES"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar en combate",
        ["frFR"] = "Active la réduction automatique du suivi de quête lors des combats.",
    },
    ["Minimize in Dungeons"] = {
        ["ptBR"] = "Minimizar em masmorras",
        ["ruRU"] = "Свернуть в подземельях",
        ["deDE"] = "In Instanzen minimieren",
        ["koKR"] = nil,
        ["esMX"] = "Minimizar en calabozos",
        ["enUS"] = true,
        ["zhCN"] = "地下城时最小化",
        ["zhTW"] = nil,
        ["esES"] = "Minimizar en mazmorras",
        ["frFR"] = "Minimiser dans les donjons",
    },
    ["When this is checked, the Tracker will automatically be minimized when entering a dungeon."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será minimizado automaticamente ao entrar em uma masmorra.",
        ["ruRU"] = "Когда включено, при входе в подземелье трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Betreten eines Dungeons automatisch minimiert.",
        ["koKR"] = nil,
        ["esMX"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar a un calabozo.",
        ["enUS"] = true,
        ["zhCN"] = "选中此项后，进入地下城时跟踪器将自动最小化。",
        ["zhTW"] = nil,
        ["esES"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar a una mazmorra.",
        ["frFR"] = "La fenêtre du suivi sera automatiquement minimisée lors de l'entrée dans un donjon.",
    },
    ["Min Complete Quests"] = {
        ["ptBR"] = "Missões mínimas concluídas",
        ["ruRU"] = "Свернуть выполненные",
        ["deDE"] = "Abgeschlossene Quests minimieren",
        ["koKR"] = "최소 완료 퀘스트",
        ["esMX"] = "Misiones mínimas completadas",
        ["enUS"] = true,
        ["zhCN"] = "收起已完成任务",
        ["zhTW"] = "收合已完成任務",
        ["esES"] = "Misiones mínimas completadas",
        ["frFR"] = "Réduire si terminée",
    },
    ["When this is checked, completed quests will automatically minimize."] = {
        ["ptBR"] = "Quando isso estiver marcado, as missões concluídas serão automaticamente minimizadas.",
        ["ruRU"] = "Когда включено, задания будут автоматически сворачиваться после их выполнения",
        ["deDE"] = "Wenn dies aktiviert ist, werden abgeschlossene Quests automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "选中后，已完成的任务将自动收起",
        ["zhTW"] = "完成的任務將自動收合",
        ["esES"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["frFR"] = "Réduit automatique les quêtes terminées.",
    },
    ["Lock Tracker"] = {
        ["ptBR"] = "Bloqueado o rastreador",
        ["ruRU"] = "Заблокировать трекер",
        ["deDE"] = "Tracker sperren",
        ["koKR"] = "추적기 잠금",
        ["esMX"] = "Bloquear rastreador",
        ["enUS"] = true,
        ["zhCN"] = "锁定框体",
        ["zhTW"] = "鎖定框架",
        ["esES"] = "Bloquear rastreador",
        ["frFR"] = "Verrouiller la fenêtre du suivi",
    },
    ["Enable Tracker Hooks"] = {
        ["ptBR"] = "Ativar ganchos do rastreador",
        ["ruRU"] = "Трекер Blizzard",
        ["deDE"] = "Tracker Hooks aktivieren",
        ["koKR"] = "트래커 후크 활성화",
        ["esMX"] = "Habilitar ganchos de seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "启用任务追踪器",
        ["zhTW"] = "接管任務追蹤",
        ["esES"] = "Habilitar ganchos de seguimiento",
        ["frFR"] = "Activer l'attache du suivi des quêtes",
    },
    ["Enable hooking the Blizzard quest tracker. This is required for some features of the Questie tracker, and to integrate with other addons. If you are having issues with quest tracking you may need to disable this (requires /reload)."] = {
        ["ptBR"] = "Ativa a conexão do rastreador de missões da Blizzard. Isso é necessário para alguns recursos do rastreador de missões e para integração com outros complementos. Se você estiver tendo problemas com o rastreamento de missões, pode ser necessário desativá-lo (requer / recarrega ).",
        ["ruRU"] = "Включить перехват трекера Blizzard. Это необходимо для некоторых функций трекера Questie и для интеграции с другими аддонами. Если у вас возникают проблемы с отслеживанием заданий, попробуйте отключить этот параметр (может потребоваться перезагрузка пользовательского интерфейса командой '/reload')",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Blizzard-Quest-Trackers eingebunden. Dies ist für einige Funktionen des Questie-Trackers und für die Integration mit anderen Addons erforderlich. Bei Problemen mit der Questverfolgung, kann versucht werden diese Option zu deaktivieren (erfordert ein /reload).",
        ["koKR"] = "블리자드 퀘스트 추적기 연결 활성화. 이것은 Questie 추적기의 일부 기능 및 다른 애드온과 통합하는 데 필요합니다. 퀘스트 추적에 문제가있는 경우이를 비활성화해야합니다 (/ 재로드 필요) ).",
        ["esMX"] = "Habilitar el enganche del rastreador de misiones de Blizzard. Esto es necesario para algunas funciones del rastreador de misiones y para integrarse con otros complementos. Si tiene problemas con el rastreo de misiones, es posible que deba desactivar esto (requiere / recargar) )",
        ["enUS"] = true,
        ["zhCN"] = "启用暴雪任务追踪器。这对于Questie追踪器的某些功能是必需的，并且与其他插件集成。如果您在任务追踪方面遇到问题，则可能需要禁用此功能（需要/ reload ）。",
        ["zhTW"] = "啟用後，Questie會以鉤子（Hook）鉤起暴雪的任務追蹤函數，接管它的功能，這對Questie任務追蹤的某些功能來說是必要的，可以使追蹤的狀態更精準地更新，同時還可以與其他插件整合。如果你的任務追蹤出現了奇怪的錯誤，可能就要停用這項功能；停用需要重載介面（/reload）",
        ["esES"] = "Habilitar el enganche del rastreador de misiones de Blizzard. Esto es necesario para algunas funciones del rastreador de misiones y para integrarse con otros complementos. Si tiene problemas con el rastreo de misiones, es posible que deba desactivar esto (requiere / recargar) )",
        ["frFR"] = "Active l'utilisation de l'attache du suivi des quêtes Blizzard. Ceci est requis pour certaines fonctionnalités du suivi des quêtes de Questie ainsi que pour la compatibilité avec d'autres addons. Si vous rencontrez des problèmes avec le suivi de quête vous pouvez essayer de désactiver cette option (requiert un /reload).",
    },
    ["This determines the direction in which the tracker grows. The default setting will adjust based on where you drag the tracker automatically or you can override it and force it to populate however you like.\n\nFor example, if you select 'Bottom Left' then the tracker will grow from Left to Right and Quests will be populated from the Bottom of the Tracker to the Top. This setting is ideal when you want the tracker to be placed in the 'Bottom Left' region of your UI etc.\n\nNOTE: If you change this setting then 'Auto Move Header' will be disabled and will remain at the top of the Tracker even while minimized."] = {
        ["ptBR"] = "Isso determina a direção na qual o rastreador cresce. A configuração padrão será ajustada com base em onde você arrasta o rastreador automaticamente ou você pode substituí-lo e forçá-lo a preencher da maneira que desejar.\n\nPor exemplo, se você selecionar 'Parte inferior esquerda', o rastreador crescerá da esquerda para a direita e as Missões serão preenchidas da parte inferior do rastreador para a parte superior. Essa configuração é ideal quando você deseja que o rastreador seja colocado na parte inferior 'Esquerda' região da sua interface do usuário etc.",
        ["ruRU"] = "Определяет направление, в котором растет трекер. Настройка 'Авто' будет регулировать направление в зависимости от того, где расположен трекер. Также можно настроить этот параметр вручную.\n\nНапример, если выбрать 'Слева внизу', то трекер будет расти слева направо, а задания будут появляться снизу вверх. Этот параметр идеален, когда трекер расположен в нижнем левом углу пользовательского интерфейса и т. п.\n\nПРИМЕЧАНИЕ: если вы измените этот параметр, то 'Автоперемещение' будет отключено, и заголовок трекера всегда будет наверху, даже если трекер свернут",
        ["deDE"] = "Hiermit wird die Richtung festgelegt, in die der Tracker wächst. Die Standardeinstellung hängt davon ab, wo der Tracker positioniert wird. Dieser Wert kann aber auch überschreiben werden.\n\nWenn z.B. 'Unten links' ausgewählen wird, wächst der Tracker von links nach rechts und Quests werden vom unteren Rand des Trackers nach oben ausgefüllt. Diese Einstellung ist ideal, wenn der Tracker 'Unten links' in der Benutzeroberfläche positioniert werden soll.",
        ["koKR"] = "이는 추적기가 커지는 방향을 결정합니다. 기본 설정은 추적기를 자동으로 드래그하는 위치에 따라 조정되거나 원하는대로 덮어 쓸 수 있습니다.\n\n예를 들어, 'Bottom Left' 를 선택하면 트래커가 왼쪽에서 오른쪽으로 커지고 퀘스트가 트래커의 맨 아래에서 맨 위로 채워집니다.이 설정은 트래커를 'Bottom', 에 배치하려는 경우에 이상적입니다. 왼쪽 'UI' 등의 영역",
        ["esMX"] = "Esto determina la dirección en la que crece el rastreador. La configuración predeterminada se ajustará según el lugar donde arrastre el rastreador automáticamente o puede anularlo y forzarlo a rellenar como desee.\n\nPor ejemplo, si selecciona 'Abajo a la izquierda', el rastreador crecerá de izquierda a derecha y las misiones se completarán desde la parte inferior del rastreador hasta la parte superior. Esta configuración es ideal cuando desea que el rastreador se coloque en la 'parte inferior Izquierda' región de su interfaz de usuario, etc.",
        ["enUS"] = true,
        ["zhCN"] = "这决定了跟踪器的伸展方向。默认设置将根据您自动拖动跟踪器的位置进行调整，也可以覆盖并强制将其填充为所需的样式。\n\n例如，如果您选择 'Bottom Left' 则跟踪器将从左向右增长，并且任务将从跟踪器的底部填充到顶部。当您希望将跟踪器放置在'Bottom'时，此设置是理想的用户界面的左侧“区域",
        ["zhTW"] = "這設定用以改變視窗往哪個方向變形。\n\n例如，如果設定錨點為'左下'，那麼視窗將會從左往右拉長，而因任務的增加，列表皆由下往上拉長。這樣的設定是當你想將任務追蹤視窗放置在畫面的左下方時。\n\n注意: 當變更這項設定後，'自動移動標題列'設定將會被停用，並將維持在任務追蹤視窗的上方",
        ["esES"] = "Esto determina la dirección en la que crece el rastreador. La configuración predeterminada se ajustará según el lugar donde arrastre el rastreador automáticamente o puede anularlo y forzarlo a rellenar como desee.\n\nPor ejemplo, si selecciona 'Abajo a la izquierda', el rastreador crecerá de izquierda a derecha y las misiones se completarán desde la parte inferior del rastreador hasta la parte superior. Esta configuración es ideal cuando desea que el rastreador se coloque en la 'parte inferior Izquierda' región de su interfaz de usuario, etc.",
        ["frFR"] = "Ceci détermine la direction dans laquelle le tracker se développe. Le paramètre par défaut sera ajusté en fonction de l'endroit où vous faites glisser le tracker automatiquement ou vous pouvez le remplacer et le forcer à se remplir comme bon vous semble.\n\nPar exemple, si vous sélectionnez 'Bottom Left', le tracker passera de gauche à droite et les quêtes seront remplies du bas du tracker vers le haut. Ce paramètre est idéal lorsque vous voulez que le tracker soit placé dans le 'Bottom Gauche' région de votre interface utilisateur, etc.",
    },
    ["Enable Background"] = {
        ["ptBR"] = "Ativar plano de fundo",
        ["ruRU"] = "Фон трекера",
        ["deDE"] = "Hintergrund anzeigen",
        ["koKR"] = "배경 사용",
        ["esMX"] = "Habilitar fondo",
        ["enUS"] = true,
        ["zhCN"] = "启用背景",
        ["zhTW"] = "顯示背景",
        ["esES"] = "Habilitar fondo",
        ["frFR"] = "Activer l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Background becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, o fundo do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть фон трекера",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Questie Tracker-Hintergrund angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기 배경이 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo del Rastreador de Questie se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示追踪器背景。",
        ["zhTW"] = "顯示背景",
        ["esES"] = "Cuando esto está marcado, el fondo del Rastreador de Questie se vuelve visible",
        ["frFR"] = "Active l'arrière-plan du suivi des quêtes Questie.",
    },
    ["Tracker Backdrop Alpha"] = {
        ["ptBR"] = "Alfa do cenário do rastreador",
        ["ruRU"] = "Непрозрачность фона",
        ["deDE"] = "Tracker Hintergrund Alpha",
        ["koKR"] = "트래커 배경 알파",
        ["esMX"] = "Alfa del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "背景透明度",
        ["zhTW"] = "背景透明度",
        ["esES"] = "Alfa del fondo del rastreador",
        ["frFR"] = "Opacité de l'arrière-plan",
    },
    ["The alpha level of the tracker backdrop"] = {
        ["ptBR"] = "O nível alfa do cenário do rastreador",
        ["ruRU"] = "Уровень непрозрачности фона трекера",
        ["deDE"] = "Das Alpha-Level des Tracker-Hintergrunds",
        ["koKR"] = "트래커 배경의 알파 수준",
        ["esMX"] = "El nivel alfa del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "设置背景的透明度",
        ["zhTW"] = "設定背景透明度",
        ["esES"] = "El nivel alfa del fondo del rastreador",
        ["frFR"] = "Définis l'opacité de l'arrière-plan du suivi des quêtes Questie.",
    },
    ["Enable Border"] = {
        ["ptBR"] = "Ativar borda",
        ["ruRU"] = "Граница фона",
        ["deDE"] = "Rahmen anzeigen",
        ["koKR"] = "테두리 활성화",
        ["esMX"] = "Habilitar borde",
        ["enUS"] = true,
        ["zhCN"] = "启用边框",
        ["zhTW"] = "顯示邊框",
        ["esES"] = "Habilitar borde",
        ["frFR"] = "Activer la bordure",
    },
    ["Fade Background"] = {
        ["ptBR"] = "Desvanecer fundo",
        ["ruRU"] = "Скрыть фон и границу",
        ["deDE"] = "Hintergrund verblassen",
        ["koKR"] = "페이드 배경",
        ["esMX"] = "Fundido de fondo",
        ["enUS"] = true,
        ["zhCN"] = "淡化背景",
        ["zhTW"] = "淡化背景",
        ["esES"] = "Fundido de fondo",
        ["frFR"] = "Fondu de l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Backdrop and Border (if enabled) will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Pano de fundo e a borda do Questie Rastreador (se ativado) desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, фон и граница трекера исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden der Hintergrund des Questie Trackers und der Rahmen (falls aktiviert) ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 배경 및 테두리 (사용 가능한 경우)가 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo y el borde del Rastreador de Questie (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中后，自动淡化背景及边框",
        ["zhTW"] = "未使用時，自動淡化背景與邊框",
        ["esES"] = "Cuando esto está marcado, el fondo y el borde del Rastreador de Questie (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu de l'arrière-plan du suivi des quêtes Questie lorsque celui-ci est activé.",
    },
    ["The tracker shortcut to show the quest in the quest log."] = {
        ["ptBR"] = "O atalho para exibir a missão de missões",
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале",
        ["deDE"] = "Der Tracker-Shortcut, um eine Quest im Questlog anzuzeigen.",
        ["koKR"] = "추적기가 퀘스트를 퀘스트 목록에서 여는 단축키를 설정합니다.",
        ["esMX"] = "El atajo del rastreador para mostrar la misión en el registro.",
        ["enUS"] = true,
        ["zhCN"] = "在任务追踪上开启任务日志的快捷键",
        ["zhTW"] = "在任務追蹤上開啟任務日誌的快捷鍵",
        ["esES"] = "El atajo del rastreador para mostrar la misión en el registro.",
        ["frFR"] = "Définit le raccourci servant à afficher la quête dans le journal des quêtes.",
    },
    ["Untrack/Link Quest"] = {
        ["ptBR"] = "Remover Rastreio/Vincular missão",
        ["ruRU"] = "Отмена/ссылка",
        ["deDE"] = "Quest verlinken/entfernen",
        ["koKR"] = "추적종료 / 링크 퀘스트",
        ["esMX"] = "No rastrear/vincular misión",
        ["enUS"] = true,
        ["zhCN"] = "停止追踪任务/连接任务",
        ["zhTW"] = "停止追蹤任務/連結任務",
        ["esES"] = "No rastrear/vincular misión",
        ["frFR"] = "Ne plus traquer et partager le lien de la quête",
    },
    ["Don't Sort"] = {
        ["ptBR"] = "Não classifique",
        ["ruRU"] = "Без сортировки",
        ["deDE"] = "Nicht sortieren",
        ["koKR"] = "정렬하지 않습니다",
        ["esMX"] = "Sin ordenar",
        ["enUS"] = true,
        ["zhCN"] = "不排序",
        ["zhTW"] = "不排序",
        ["esES"] = "Sin ordenar",
        ["frFR"] = "Ne pas trier",
    },
    ["When this is checked, the Questie Tracker Border becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, a borda do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть границу фона трекера",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Rand des Questie Trackers sichtbar.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 테두리가 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el borde del Rastreador de Questie se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示边框。",
        ["zhTW"] = "顯示邊框",
        ["esES"] = "Cuando esto está marcado, el borde del Rastreador de Questie se vuelve visible",
        ["frFR"] = "Active la bordure du suivi des quêtes Questie.",
    },
    ["Sticky Durability Frame"] = {
        ["ptBR"] = "Quadro de durabilidade aderente",
        ["ruRU"] = "Индикатор прочности",
        ["deDE"] = "Starre Haltbarkeitsanzeige",
        ["koKR"] = "달라붙는 프레임",
        ["esMX"] = "Marco de durabilidad fijo",
        ["enUS"] = true,
        ["zhCN"] = "锁定任务道具",
        ["zhTW"] = "顯示耐用度視窗",
        ["esES"] = "Marco de durabilidad fijo",
        ["frFR"] = "Ajust auto durabilité",
    },
    ["When this is checked, the durability frame will be placed on the left or right side of the Tracker depending on where the Tracker is placed on your screen."] = {
        ["ptBR"] = "Quando isso estiver marcado, o quadro de durabilidade será colocado no lado esquerdo ou direito do Rastreador, dependendo de onde o Rastreador estiver colocado na tela.",
        ["ruRU"] = "Когда включено, индикатор прочности снаряжения будет расположен с левой или правой стороны трекера (в зависимости от положения трекера на экране)",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird die Haltbarkeitsanzeige auf der linken oder rechten Seite des Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["koKR"] = "이 옵션을 선택하면 화면에서 트래커의 위치에 따라 내구성 프레임이 트래커의 왼쪽 또는 오른쪽에 배치됩니다.",
        ["esMX"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del Rastreador, dependiendo de dónde esté ubicado el Rastreador en su pantalla.",
        ["enUS"] = true,
        ["zhCN"] = "选中此选项时，道具框架将根据追踪器在屏幕上的放置位置放置在追踪器的左侧或右侧。",
        ["zhTW"] = "將耐用度視窗顯示在任務追蹤視窗的左邊",
        ["esES"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del Rastreador, dependiendo de dónde esté ubicado el Rastreador en su pantalla.",
        ["frFR"] = "Active le placement automatique du cadre de durabilité sur le côté gauche ou droit de la fenêtre de suivi selon l'endroit où celle-ci se trouve sur l'écran.",
    },
    ["Removes a quest from the Tracker when the chat input box is not visible, otherwise this will link a quest to chat."] = {
        ["ptBR"] = "Remove uma missão do Rastreador quando a caixa de entrada do bate-papo não está visível, caso contrário, isso vinculará uma missão ao bate-papo.",
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания в трекере. Если активно окно ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание",
        ["deDE"] = "Entfernt eine Quest aus dem Tracker oder verlinkt sie in den Chat, wenn das Eingabefenster des Chats gezeigt ist.",
        ["koKR"] = "대화 입력 상자가 보이지 않을 때 추적기에서 퀘스트를 제거합니다. 그렇지 않으면 퀘스트를 채팅으로 연결합니다.",
        ["esMX"] = "Elimina una misión del Rastreador cuando el cuadro de entrada del chat no está visible; de lo contrario, esto vinculará una misión al chat.",
        ["enUS"] = true,
        ["zhCN"] = "当聊天框文字输入未被开启时，将所选任务从任务追踪框体内移除；当聊天框文字输入被开启时，贴上任务连接到聊天框内。",
        ["zhTW"] = "當聊天室窗文字輸入未被開啟時，將所選任務從任務追蹤視窗移除；當聊天室窗文字輸入被開啟時，貼上任務連結到對話視窗",
        ["esES"] = "Elimina una misión del Rastreador cuando el cuadro de entrada del chat no está visible; de lo contrario, esto vinculará una misión al chat.",
        ["frFR"] = "Enlève une quête du traqueur quand la fenêtre de chat n'est pas visible, sinon poste le lien de la quête dans le chat",
    },
    ["Padding Between Quests"] = {
        ["ptBR"] = "Preenchimento entre missões",
        ["ruRU"] = "Отступ между заданиями",
        ["deDE"] = "Abstand zwischen Quests",
        ["koKR"] = "퀘스트간 간격 설정",
        ["esMX"] = "Espaciado ente misiones",
        ["enUS"] = true,
        ["zhCN"] = "任务间距",
        ["zhTW"] = "任務間距",
        ["esES"] = "Espaciado ente misiones",
        ["frFR"] = "Espacement entre les quêtes",
    },
    ["The amount of padding between quests in the tracker."] = {
        ["ptBR"] = "A quantidade de preenchimento entre as missões no Rastreador",
        ["ruRU"] = "Установка отступа между заданиями в трекере",
        ["deDE"] = "Der Abstand zwischen den Quests im Tracker.",
        ["koKR"] = "추적기에서 퀘스트간 간격을 설정합니다.",
        ["esMX"] = "La cantidad de espacio entre misiones en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "追踪列表中，每个任务的间距",
        ["zhTW"] = "追蹤列表中，每個任務的間距",
        ["esES"] = "La cantidad de espacio entre misiones en el rastreador.",
        ["frFR"] = "Définis l'espacement entre les quêtes dans la liste du suivi.",
    },
    ["Font Size for Quest Titles"] = {
        ["ptBR"] = "Tamanho da fonte dos títulos das missões",
        ["ruRU"] = "Размер шрифта названий заданий",
        ["deDE"] = "Schriftgröße für Questtitel",
        ["koKR"] = "퀘스트 제목의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para títulos de búsqueda",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体大小",
        ["zhTW"] = "任務標題字體大小",
        ["esES"] = "Tamaño de fuente para títulos de búsqueda",
        ["frFR"] = "Taille de police pour les titres de quête",
    },
    ["Font for Quest Titles"] = {
        ["ptBR"] = "Fonte para títulos de missão",
        ["ruRU"] = "Шрифт названий заданий",
        ["deDE"] = "Schriftart für Questtitel",
        ["koKR"] = "퀘스트 타이틀용 글꼴",
        ["esMX"] = "Fuente para los títulos de misión",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体",
        ["zhTW"] = "任務標題字體",
        ["esES"] = "Fuente para los títulos de Misión",
        ["frFR"] = "Police pour les titres de quête",
    },
    ["The font used for quest titles."] = {
        ["ptBR"] = "A fonte usada para os títulos das missões.",
        ["ruRU"] = "Шрифт, используемый в названиях заданий",
        ["deDE"] = "Die Schriftart die für Questtitel verwendet wird.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los títulos de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "任务标题使用的字体。",
        ["zhTW"] = "任務標題顯示的字體",
        ["esES"] = "La fuente utilizada para los títulos de misiones.",
        ["frFR"] = "La police utilisée pour les titres de quête.",
    },
    ["Font for Active Quests"] = {
        ["ptBR"] = "Fonte para missões ativas",
        ["ruRU"] = "Шрифт заголовка трекера",
        ["deDE"] = "Schriftart für aktive Quests",
        ["koKR"] = "활성 퀘스트를위한 글꼴",
        ["esMX"] = "Fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务的字体",
        ["zhTW"] = "標題列字體",
        ["esES"] = "Fuente para misiones activas",
        ["frFR"] = "Police pour les quêtes actives",
    },
    ["The font Active Quests uses."] = {
        ["ptBR"] = "A fonte Missões ativas usa.",
        ["ruRU"] = "Шрифт, используемый в заголовке трекера",
        ["deDE"] = "Die Schriftart die für aktive Quests verwendet wird.",
        ["koKR"] = "액티브 퀘스트 글꼴이 사용합니다.",
        ["esMX"] = "La fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体。",
        ["zhTW"] = "標題列顯示的字體",
        ["esES"] = "La fuente que utiliza misiones activas.",
        ["frFR"] = "La police utilisée par Active Quests.",
    },
    ["Font Size for Active Quests"] = {
        ["ptBR"] = "Tamanho da fonte para missões ativas",
        ["ruRU"] = "Размер шрифта заголовка трекера",
        ["deDE"] = "Schriftgröße für aktive Quests",
        ["koKR"] = "활성 퀘스트의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务字体大小",
        ["zhTW"] = "標題列字體大小",
        ["esES"] = "Tamaño de fuente para misiones activas",
        ["frFR"] = "Taille de police pour les quêtes actives",
    },
    ["The font size Active Quests uses."] = {
        ["ptBR"] = "O tamanho da fonte que o Missões ativas usa.",
        ["ruRU"] = "Размер шрифта, используемого в заголовке трекера",
        ["deDE"] = "Die Schriftgröße die für aktive Quests verwendet wird.",
        ["koKR"] = "Active Quests에서 사용하는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体大小。",
        ["zhTW"] = "標題列顯示的字體大小",
        ["esES"] = "El tamaño de fuente que utiliza misiones activas.",
        ["frFR"] = "Taille de police utilisée par Active Quests.",
    },
    ["Font Size for Zone Names"] = {
        ["ptBR"] = "Tamanho da fonte para nomes de zonas",
        ["ruRU"] = "Размер шрифта названий игровых зон",
        ["deDE"] = "Schriftgröße für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体大小",
        ["zhTW"] = "區域名稱字體大小",
        ["esES"] = "Tamaño de fuente para nombres de zona",
        ["frFR"] = "Taille de police pour les noms de zone",
    },
    ["The font size used for zone names."] = {
        ["ptBR"] = "O tamanho da fonte usada para nomes de zonas.",
        ["ruRU"] = "Размер шрифта, используемого в названиях игровых зон",
        ["deDE"] = "Die Schriftgröße die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体大小。",
        ["zhTW"] = "區域名稱顯示的字體大小",
        ["esES"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["frFR"] = "La taille de police utilisée pour les noms de zone.",
    },
    ["Font for Zone Names"] = {
        ["ptBR"] = "Fonte para nomes de zonas",
        ["ruRU"] = "Шрифт названий игровых зон",
        ["deDE"] = "Schriftart für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴",
        ["esMX"] = "Fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体",
        ["zhTW"] = "區域名稱字體",
        ["esES"] = "Fuente para nombres de zona",
        ["frFR"] = "Police pour les noms de zone",
    },
    ["The font used for zone names."] = {
        ["ptBR"] = "A fonte usada para nomes de zona.",
        ["ruRU"] = "Шрифт, используемый в названиях игровых зон",
        ["deDE"] = "Die Schriftart die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体",
        ["zhTW"] = "區域名稱顯示的字體",
        ["esES"] = "La fuente utilizada para los nombres de zona.",
        ["frFR"] = "La police utilisée pour les noms de zone.",
    },
    ["The font size used for quest titles."] = {
        ["ptBR"] = "O tamanho da fonte usada para os títulos das missões.",
        ["ruRU"] = "Размер шрифта, используемого в названиях заданий",
        ["deDE"] = "Die Schriftgröße die für Questtitel verwendet wird.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los títulos de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "任务标题使用的字体大小",
        ["zhTW"] = "任務標題顯示的字體大小",
        ["esES"] = "El tamaño de fuente utilizado para los títulos de misiones.",
        ["frFR"] = "La taille de police utilisée pour les titres de quête.",
    },
    ["Font for Objectives"] = {
        ["ptBR"] = "Fonte para objetivos",
        ["ruRU"] = "Шрифт целей",
        ["deDE"] = "Schriftart für Questziele",
        ["koKR"] = "목표를위한 글꼴",
        ["esMX"] = "Fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体",
        ["zhTW"] = "任務標的字體",
        ["esES"] = "Fuente para objetivos",
        ["frFR"] = "Police pour objectifs",
    },
    ["The font used for objectives."] = {
        ["ptBR"] = "A fonte usada para objetivos.",
        ["ruRU"] = "Шрифт, используемый в наименовании целей",
        ["deDE"] = "Die Schriftart die für Questziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标的字体。",
        ["zhTW"] = "任務標的顯示的字體",
        ["esES"] = "La fuente utilizada para los objetivos.",
        ["frFR"] = "La police utilisée pour les objectifs.",
    },
    ["Font Size for Objectives"] = {
        ["ptBR"] = "Tamanho da fonte para objetivos",
        ["ruRU"] = "Размер шрифта целей",
        ["deDE"] = "Schriftgröße für Questziele",
        ["koKR"] = "목표를위한 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体大小",
        ["zhTW"] = "任務標的字體大小",
        ["esES"] = "Tamaño de fuente para objetivos",
        ["frFR"] = "Taille de police pour les objectifs",
    },
    ["The font size used for objectives."] = {
        ["ptBR"] = "O tamanho da fonte usada para os objetivos.",
        ["ruRU"] = "Размер шрифта, используемого в наименованиях целей",
        ["deDE"] = "Die Schriftgröße die für Questziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标使用的字体大小",
        ["zhTW"] = "任務標的顯示的字體大小",
        ["esES"] = "El tamaño de fuente utilizado para los objetivos.",
        ["frFR"] = "La taille de police utilisée pour les objectifs.",
    },
    ["Tracker SetPoint"] = {
        ["ptBR"] = "Rastreador SetPoint",
        ["ruRU"] = "Положение трекера",
        ["deDE"] = "Tracker Positionierung",
        ["koKR"] = "트래커 설정점",
        ["esMX"] = "Punto fijo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "追踪器设定锚点",
        ["zhTW"] = "任務追蹤視窗錨點",
        ["esES"] = "Punto fijo del rastreador",
        ["frFR"] = "Assigner la position du traqueur",
    },
    ["Top Left"] = {
        ["ptBR"] = "Superior esquerdo",
        ["ruRU"] = "Слева вверху",
        ["deDE"] = "Oben links",
        ["koKR"] = "왼쪽 상단",
        ["esMX"] = "Arriba a la izquierda",
        ["enUS"] = true,
        ["zhCN"] = "左上",
        ["zhTW"] = "左上",
        ["esES"] = "Arriba a la izquierda",
        ["frFR"] = "En haut à gauche",
    },
    ["Top Right"] = {
        ["ptBR"] = "Superior direito",
        ["ruRU"] = "Справа вверху",
        ["deDE"] = "Oben rechts",
        ["koKR"] = "오른쪽 상단",
        ["esMX"] = "Arriba a la derecha",
        ["enUS"] = true,
        ["zhCN"] = "右上",
        ["zhTW"] = "右上",
        ["esES"] = "Arriba a la derecha",
        ["frFR"] = "En haut à droite",
    },
    ["Bottom Left"] = {
        ["ptBR"] = "Parte inferior esquerda",
        ["ruRU"] = "Слева внизу",
        ["deDE"] = "Unten links",
        ["koKR"] = "왼쪽 하단",
        ["esMX"] = "Abajo a la izquierda",
        ["enUS"] = true,
        ["zhCN"] = "左下",
        ["zhTW"] = "左下",
        ["esES"] = "Abajo a la izquierda",
        ["frFR"] = "En bas à gauche",
    },
    ["Bottom Right"] = {
        ["ptBR"] = "Parte inferior direita",
        ["ruRU"] = "Справа внизу",
        ["deDE"] = "Unten rechts",
        ["koKR"] = "오른쪽 하단",
        ["esMX"] = "Abajo a la derecha",
        ["enUS"] = true,
        ["zhCN"] = "右下",
        ["zhTW"] = "右下",
        ["esES"] = "Abajo a la derecha",
        ["frFR"] = "En bas à droite",
    },
    ["When this is checked, the Questie Tracker Header will automatically move to the bottom of the Questie Tracker while the Tracker is placed in the bottom area of your screen. Otherwise, it will remain at the top always.\n\nNOTE: This setting only works while the 'Tracker SetPoint' is using the default 'Auto' mode."] = {
        ["ptBR"] = "Quando isso estiver marcado, o cabeçalho do Questie Rastreador passará automaticamente para a parte inferior do Questie Rastreador enquanto o Rastreador estiver na área inferior da tela. Caso contrário, ele permanecerá sempre no topo.\n\nNOTA: essa configuração funciona apenas enquanto o'Rastreador SetPoint' estiver usando o modo 'Automático' padrão.",
        ["ruRU"] = "Когда включено, заголовок трекера автоматически перемещается вниз, если трекер расположен в нижней половине экрана. В противном случае, заголовок всегда остается наверху.\n\nПРИМЕЧАНИЕ: это параметр работает только тогда, когда в опции 'Положение трекера' выбран режим 'Авто'",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Questie Tracker-Header automatisch an den unteren Rand des Questie Tracker verschoben, während sich der Tracker im unteren Bereich Ihres Bildschirms befindet. Andernfalls bleibt es immer oben.\n\nHINWEIS: Diese Einstellung funktioniert nur, wenn der 'Tracker SetPoint' den Standardmodus 'Automatisch' verwendet.",
        ["koKR"] = "이 옵션을 선택하면 트래커가 화면 하단에 배치되어있는 동안 Questie 트래커 헤더가 자동으로 Questie 트래커 하단으로 이동합니다. 그렇지 않으면 항상 맨 위에 유지됩니다.\n\n참고 :이 설정은 'Tracker SetPoint'가 기본 '자동'모드를 사용하는 동안에 만 작동합니다.",
        ["esMX"] = "Cuando está marcado, el Encabezado del Rastreador de Questie se moverá automáticamente a la parte inferior del Rastreador de Questie mientras el Rastreador se coloca en la parte inferior de la pantalla. De lo contrario, permanecerá en la parte superior siempre.\n\nNOTA: Esta configuración solo funciona mientras el 'Tracker SetPoint' está usando el modo predeterminado 'Automático'.",
        ["enUS"] = true,
        ["zhCN"] = "当选中此选项时，当追踪放置在屏幕底部时，Questie 追踪标题将自动移至Questie 追踪的底部。否则，它将始终保持在顶部。\n\n注意：此设置仅在 'Tracker SetPoint' 使用默认的 'Auto' 模式时有效。",
        ["zhTW"] = "Questie的標題列將會自動選擇在上方或下方顯示。\n\n注意：僅在自動移動標題列被啟用才有效",
        ["esES"] = "Cuando está marcado, el Encabezado del Rastreador de Questie se moverá automáticamente a la parte inferior del Rastreador de Questie mientras el Rastreador se coloca en la parte inferior de la pantalla. De lo contrario, permanecerá en la parte superior siempre.\n\nNOTA: Esta configuración solo funciona mientras el 'Tracker SetPoint' está usando el modo predeterminado 'Automático'.",
        ["frFR"] = "Active l'ajustement automatique de l'en-tête afin que celui-ci soit placé en bas de la fenêtre du suivi des quêtes lorsqu'elle est placée en bas de l'écran. Autrement l'en-tête sera affichée en haut de la fenêtre de suivi. \n\nNOTE : Cette option ne peut fonctionner que si 'Tracker SetPoint' utilise le réglage par défaut 'Auto'",
    },
    ["Enable Header"] = {
        ["ptBR"] = "Ativar cabeçalho",
        ["ruRU"] = "Заголовок трекера",
        ["deDE"] = "Header anzeigen",
        ["koKR"] = "헤더 활성화",
        ["esMX"] = "Habilitar encabezado",
        ["enUS"] = true,
        ["zhCN"] = "启用标题",
        ["zhTW"] = "顯示標題列",
        ["esES"] = "Habilitar encabezado",
        ["frFR"] = "Activer l'en-tête",
    },
    ["When this is checked, the Questie Tracker Header will become visible and the total number of quests you have in your log will be shown."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Cabeçalho do Rastreador de Missões ficará visível e o número total de missões que você possui no seu registro será mostrado.",
        ["ruRU"] = "Показать/скрыть заголовок трекера. В нем показано текущее и доступное количество заданий в вашем журнале",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Questie Tracker-Header angezeigt und die Gesamtzahl der Quests im Questlog wird angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기 헤더가 표시되고 로그에있는 총 퀘스트 수가 표시됩니다.",
        ["esMX"] = "Cuando esto esté marcado, el Encabezado del Rastreador de Questie se hará visible y se mostrará el número total de misiones que tienes en tu registro",
        ["enUS"] = true,
        ["zhCN"] = "选中后，“ Questie 追踪标题”将变为可见，并且将显示您在日志中拥有的任务总数。",
        ["zhTW"] = "顯示Questie標題列並包含目前的任務總數",
        ["esES"] = "Cuando esto esté marcado, el Encabezado del Rastreador de Questie se hará visible y se mostrará el número total de misiones que tienes en tu registro",
        ["frFR"] = "Active l'affichage de l'en-tête du suivi des quêtes. Le nombre total de quêtes que vous avez dans votre journal y sera affiché.",
    },
    ["Show Complete Quests"] = {
        ["ptBR"] = "Mostrar Missões Completas",
        ["ruRU"] = "Выполненные задания",
        ["deDE"] = "Abgeschlossene Quests anzeigen",
        ["koKR"] = "완료된 퀘스트 표시",
        ["esMX"] = "Mostrar misiones completas",
        ["enUS"] = true,
        ["zhCN"] = "显示已完成的任务",
        ["zhTW"] = "顯示已完成的任務",
        ["esES"] = "Mostrar misiones completas",
        ["frFR"] = "Quêtes terminées",
    },
    ["If the Questie tracker is stuck offscreen or lost, you can reset it's location to the center of the screen with this button (may require /reload)."] = {
        ["ptBR"] = "Se o rastreador do Questie estiver preso fora da tela ou perdido, você poderá redefinir sua localização para o centro da tela com este botão (pode exigir / recarregar).",
        ["ruRU"] = "Если трекер исчез полностью или оказался за пределами экрана, то нажатие этой кнопки сбросит его положение в центр экрана (может потребоваться перезагрузка пользовательского интерфейса командой '/reload')",
        ["deDE"] = "Wenn der Questie-Tracker außerhalb des Bildschirms hängen bleibt oder verloren geht, kann seine Position mit dieser Schaltfläche auf die Mitte des Bildschirms zurückgesetzt werden (erfordert möglicherweise ein /reload).",
        ["koKR"] = "Questie 트래커가 화면을 벗어나거나 잃어버린 경우이 버튼을 사용하여 화면 중앙으로 위치를 재설정 할 수 있습니다 (/ 재로드 필요).",
        ["esMX"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón (puede requerir / volver a cargar).",
        ["enUS"] = true,
        ["zhCN"] = "如果Questie追踪器卡在屏幕外或丢失，您可以使用此按钮将其位置重置到屏幕中央（可能需要重载界面 /reload）。",
        ["zhTW"] = "如果Questie任務追蹤的框架卡住了或不小心跑到畫面之外，你可以將它的位置重設回畫面中央，這可能需要重載介面（/reload）",
        ["esES"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón (puede requerir / volver a cargar).",
        ["frFR"] = "Si le suivi des quêtes Questie est bloqué hors écran ou perdu, vous pouvez réinitialiser son emplacement au centre de l'écran avec ce bouton (peut nécessiter de /reload).",
    },
    ["Drag while Locked"] = {
        ["ptBR"] = "Arraste enquanto estiver bloqueado",
        ["ruRU"] = "Перетаскивать, если заблокирован",
        ["deDE"] = "Ziehen, während gesperrt",
        ["koKR"] = "잠금 상태에서 드래그",
        ["esMX"] = "Arrastra mientras está bloqueado",
        ["enUS"] = true,
        ["zhCN"] = "锁定时拖动",
        ["zhTW"] = "鎖定時拖動",
        ["esES"] = "Arrastra mientras está bloqueado",
        ["frFR"] = "Glisser pendant le verrouillage",
    },
    ["Drag while Unlocked"] = {
        ["ptBR"] = "Arraste enquanto desbloqueado",
        ["ruRU"] = "Перетаскивать, если разблокирован",
        ["deDE"] = "Ziehen, während entsperrt",
        ["koKR"] = "잠금 해제 상태에서 드래그",
        ["esMX"] = "Arrastre mientras está desbloqueado",
        ["enUS"] = true,
        ["zhCN"] = "解锁时拖动",
        ["zhTW"] = "解鎖時拖動",
        ["esES"] = "Arrastre mientras está desbloqueado",
        ["frFR"] = "Glisser pendant le déverrouillage",
    },
    ["Disable The Tracker"] = {
        ["ptBR"] = "Desativar o rastreador",
        ["ruRU"] = "Отключить трекер",
        ["deDE"] = "Deaktiviere den Tracker",
        ["koKR"] = "트래커 비활성화",
        ["esMX"] = "Deshabilitar el rastreador",
        ["enUS"] = true,
        ["zhCN"] = "禁用追踪器",
        ["zhTW"] = "停用Questie任務追蹤",
        ["esES"] = "Deshabilitar el rastreador",
        ["frFR"] = "Suivi par défaut",
    },
    ["Disabling the Tracker will replace the Questie Tracker with the default Blizzard Quest Tracker."] = {
        ["ptBR"] = "Desativar o Rastreador substituirá o Questie Rastreador pelo Blizzard Quest Rastreador padrão.",
        ["ruRU"] = "После нажатия трекер Questie заменится трекером Blizzard",
        ["deDE"] = "Durch Deaktivieren des Trackers wird der Questie-Tracker durch den Standard-Blizzard-Quest-Tracker ersetzt.",
        ["koKR"] = "추적기를 비활성화하면 Questie 추적기가 기본 블리자드 퀘스트 추적기로 대체됩니다.",
        ["esMX"] = "Deshabilitar el Rastreador reemplazará el Rastreador de misiones con el Rastreador de misiones de Blizzard predeterminado.",
        ["enUS"] = true,
        ["zhCN"] = "禁用跟踪器会将Questie追踪器替换为默认的暴雪任务追踪器。",
        ["zhTW"] = "停用Questie任務追蹤並回復暴雪內建的任務追蹤框架",
        ["esES"] = "Deshabilitar el Rastreador reemplazará el Rastreador de misiones con el Rastreador de misiones de Blizzard predeterminado.",
        ["frFR"] = "L'activation du suivi des quêtes par défaut remplacera le suivi des quêtes Questie.",
    },
    ["Enable The Tracker"] = {
        ["ptBR"] = "Ativar o rastreador",
        ["ruRU"] = "Включить трекер",
        ["deDE"] = "Den Tracker anzeigen",
        ["koKR"] = "트래커 활성화",
        ["esMX"] = "Habilitar el rastreador",
        ["enUS"] = true,
        ["zhCN"] = "启用跟踪器",
        ["zhTW"] = "啟用Questie任務追蹤",
        ["esES"] = "Habilitar el rastreador",
        ["frFR"] = "Suivi Questie",
    },
    ["Enabling the Tracker will replace the default Blizzard Quest Tracker with the Questie Tracker."] = {
        ["ptBR"] = "A ativação do Rastreador substituirá o Blizzard Quest Rastreador padrão pelo Questie Rastreador.",
        ["ruRU"] = "После нажатия трекер Blizzard заменится трекером Questie",
        ["deDE"] = "Durch Aktivieren des Trackers wird der Standard-Blizzard-Quest-Tracker durch den Questie-Tracker ersetzt.",
        ["koKR"] = "추적기를 활성화하면 기본 블리자드 퀘스트 추적기가 Questie 추적기로 대체됩니다.",
        ["esMX"] = "Habilitar el Rastreador reemplazará el Rastreador de misiones de Blizzard predeterminado con el Rastreador de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "启用跟踪器会将默认的暴雪自带任务追踪器替换为Questie追踪器。",
        ["zhTW"] = "使用Questie任務追蹤來取代暴雪內建的任務追蹤框架",
        ["esES"] = "Habilitar el Rastreador reemplazará el Rastreador de misiones de Blizzard predeterminado con el Rastreador de misiones.",
        ["frFR"] = "L'activation du suivi des quêtes Questie remplacera le suivi des quêtes par défaut.",
    },
    ["Reset Tracker Position"] = {
        ["ptBR"] = "Redefinir posição do rastreador",
        ["ruRU"] = "Сброс позиции",
        ["deDE"] = "Tracker-Position zurücksetzen",
        ["koKR"] = "추적기 위치 재설정",
        ["esMX"] = "Restablecer posición del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "重置追踪器位置",
        ["zhTW"] = "重設追蹤框架位置",
        ["esES"] = "Restablecer posición del rastreador",
        ["frFR"] = "Réinitialiser position",
    },
    ["Save Tracker Per Char"] = {
        ["ptBR"] = "Salvar rastreador por personagem",
        ["ruRU"] = "Сохранить отдельно",
        ["deDE"] = "Tracker pro Char speichern",
        ["koKR"] = "문자 당 트래커 저장",
        ["esMX"] = "Guardar Rastreador por Char",
        ["enUS"] = true,
        ["zhCN"] = "根据角色自定义设置",
        ["zhTW"] = "每一腳色自訂設定",
        ["esES"] = "Guardar Rastreador por Char",
        ["frFR"] = "Réglages par perso",
    },
    ["You are currently saving the Questie Tracker Location and Size Per Character. This allows you to cusomize each character's tracker location.\n\nNOTE: Upon enabling Per Character, the Tracker will be reset to the center of your screen. Move the Tracker to your desired location and set the size. When you are ready, type '/reload' to finalize your settings."] = {
        ["ptBR"] = "No momento, você está salvando o local do Questie Rastreador e o tamanho por personagem. Isso permite que você personalize a localização do rastreador de cada personagem.\n\nNOTA: Ao ativar o Per Character, o rastreador será redefinido no centro do seu Mova o Rastreador para o local desejado e defina o tamanho. Quando estiver pronto, digite '/recarregar' para finalizar suas configurações.",
        ["ruRU"] = "В данный момент положение и размер трекера сохраняются для каждого персонажа отдельно.\n\nПРИМЕЧАНИЕ: при изменении параметра положение трекера будет сброшено в центр экрана. После этого нужно переместить трекер в необходимое место и установить его размер. Для завершения настройки нужно перезагрузить пользовательский интерфейс командой '/reload'",
        ["deDE"] = "Die Position und Größe des Questie-Trackers wird aktuell pro Charakter gespeichert. Auf diese Weise kann der Tracker-Standort auf jeden Charakters unterschiedlich eingestellt werden.\n\nHINWEIS: Wenn 'Pro Charakter' aktiviert wird, wird die Position des Trackers zurückgesetzt. Anschließend sollte der Tracker an den gewünschten Ort verschoeben und die Größe passen eingestellt werden. Das Einstellen wird mit einem '/reload' abgeschlossen.",
        ["koKR"] = "현재 Questie Tracker 위치 및 문자 당 크기를 저장하고 있습니다. 이렇게하면 각 문자의 추적기 위치를 조절할 수 있습니다.\n\n참고 : 문자 별을 활성화하면 추적기가 중앙으로 재설정됩니다. 추적기를 원하는 위치로 이동하고 크기를 설정하십시오. 준비가되면 '/reload'를 입력하여 설정을 완료하십시오.",
        ["esMX"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie por personaje. Esto le permite personalizar la ubicación del rastreador de cada personaje.\n\nNOTA: Al habilitar Por personaje, el Tracker se reiniciará en el centro de su pantalla. Mueva el Rastreador a su ubicación deseada y configure el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["enUS"] = true,
        ["zhCN"] = "您当前正在保存Questie追踪窗口的位置和大小。这使您可以自定义每个角色的不同设定。\n\n注意：启用这个设定后，跟踪器将重置为您的屏幕中间。将追踪窗口移至你想要的位置并设置大小。设置好后，输入'/reload'完成设置。",
        ["zhTW"] = "將Questie任務追蹤視窗的位置與大小針對每一腳色做個別儲存。這可讓你每一不同腳色擁有不同設定。\n\n注意: 啟用這設定時，會先將視窗重設到畫面中央。將任務追蹤視窗移動您想要的位置，並調整好大小。完成後，輸入'/reload'來完成所有設定。",
        ["esES"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie por personaje. Esto le permite personalizar la ubicación del rastreador de cada personaje.\n\nNOTA: Al habilitar Por personaje, el Tracker se reiniciará en el centro de su pantalla. Mueva el Rastreador a su ubicación deseada y configure el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["frFR"] = "Vous enregistrez actuellement vos réglages pour ce personnage uniquement. Cela vous permet de personnaliser l'emplacement du suivi des quêtes pour chacun de vos personnages.\n\nREMARQUE : L'activation de ce mode réinitialisera la fenêtre de suivi au centre de l'écran. Déplacez-la à l'emplacement souhaité et définissez-en la taille. Tapez ensuite '/reload' pour enregistrer vos réglages. ",
    },
    ["Save Tracker Global"] = {
        ["ptBR"] = "Salvar global do rastreador",
        ["ruRU"] = "Сохранить глобально",
        ["deDE"] = "Tracker global speichern",
        ["koKR"] = "추적기 글로벌 저장",
        ["esMX"] = "Guardar Rastreador Global",
        ["enUS"] = true,
        ["zhCN"] = "所有角色统一设定",
        ["zhTW"] = "所有腳色統一設定",
        ["esES"] = "Guardar Rastreador Global",
        ["frFR"] = "Réglages partagés",
    },
    ["You are currently saving the  Questie Tracker Location and Size Globally. This allows you to have one setting for all characters.\n\nNOTE: Upon enabling Global, the Tracker will be reset to the center of your screen. Move the Tracker to your desired location and set the size. When you are ready, type '/reload' to finalize your settings."] = {
        ["ptBR"] = "No momento, você está salvando o local e o tamanho do Questie Rastreador globalmente. Isso permite que você tenha uma configuração para todos os caracteres.\n\nNOTA: Ao ativar Global, o Rastreador será redefinido para o centro da tela Mova o Rastreador para o local desejado e defina o tamanho. Quando estiver pronto, digite '/recarregar' para finalizar suas configurações.",
        ["ruRU"] = "В данный момент положение и размер трекера сохраняются одинаково для всех персонажей.\n\nПРИМЕЧАНИЕ: при изменении параметра положение трекера будет сброшено в центр экрана. После этого нужно переместить трекер в необходимое место и установить его размер. Для завершения настройки нужно перезагрузить пользовательский интерфейс командой '/reload'",
        ["deDE"] = "Die Position und Größe des Questie-Trackers wird aktuell global gespeichert. Auf diese Weise kann der Tracker-Standort für alle Charakter gleichermaßen eingestellt werden.\n\nHINWEIS: Wenn 'Pro Charakter' aktiviert wird, wird die Position des Trackers zurückgesetzt. Anschließend sollte der Tracker an den gewünschten Ort verschoeben und die Größe passen eingestellt werden. Das Einstellen wird mit einem '/reload' abgeschlossen.",
        ["koKR"] = "현재 Questie 추적기 위치 및 크기를 전역으로 저장하고 있습니다. 모든 문자에 대해 하나의 설정을 지정할 수 있습니다.\n\n참고 : 전역을 활성화하면 추적기가 화면 중앙으로 재설정됩니다. 추적기를 원하는 위치로 이동하고 크기를 설정하십시오. 준비가되면 '/reload'를 입력하여 설정을 완료하십시오.",
        ["esMX"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie a nivel mundial. Esto le permite tener una configuración para todos los caracteres.\n\nNOTA: Al habilitar Global, el Tracker se restablecerá en el centro de su pantalla . Mueva el Rastreador a su ubicación deseada y establezca el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["enUS"] = true,
        ["zhCN"] = "您当前正在全局保存Questie追踪窗口的位置和大小。这使您可以对所有角色进行一次设置。\n\n注意：启用这项设定后，追踪将会重置到屏幕中心。将追踪移至所需位置并设置大小。设置好后，输入'/reload'完成设置。",
        ["zhTW"] = "將Questie任務追蹤視窗的位置與大小針對所有腳色做統一儲存。這可讓你對所有腳色擁有單一設定。\n\n注意: 啟用這設定時，會先將視窗重設到畫面中央。將任務追蹤視窗移動您想要的位置，並調整好大小。完成後，輸入'/reload'來完成所有設定。",
        ["esES"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie a nivel mundial. Esto le permite tener una configuración para todos los caracteres.\n\nNOTA: Al habilitar Global, el Tracker se restablecerá en el centro de su pantalla . Mueva el Rastreador a su ubicación deseada y establezca el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["frFR"] = "Vous enregistrez actuellement vos réglages de façon partagée. Cela vous permet d'avoir une seule configuration partagée entre tous vos personnages.\n\nREMARQUE : L'activation de ce mode réinitialisera la fenêtre de suivi au centre de l'écran. Déplacez-la à l'emplacement souhaité et définissez-en la taille. Tapez ensuite '/reload' pour enregistrer vos réglages.",
    },
}

for k, v in pairs(trackerOptionsLocales) do
    l10n.translations[k] = v
end
